#pragma once

#include "BowerShader.h"

using namespace std;
using namespace DirectX;

//The type of billboard geometry to draw
enum GeometryType
{
	Grass,
	Tree
};

//Shader for creating billboarded sprites
class BillboardGeometryShader : public BowerShader
{
	public:
		struct BillboardBufferType
		{
			XMFLOAT4 cameraPosition;	//Pass the camera position so the billboard position can be calculated
		};

		struct BillboardPositionsBufferType
		{
			XMFLOAT4 positions[4];	//Positions of each vertex of the quad
		};

		BillboardGeometryShader(ID3D11Device* device, HWND hwnd);
		~BillboardGeometryShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &world, const XMMATRIX &view, const XMMATRIX &projection, XMFLOAT3 cameraPosition, GeometryType type, ID3D11ShaderResourceView* billboardTexture, ID3D11ShaderResourceView* sunShadowMap, ID3D11ShaderResourceView* spotShadowMap, ID3D11ShaderResourceView* hillShadowMaps[6], float constant, float linear, float quadratic);

	private:
		void initShader(const wchar_t* vsFilename, const wchar_t* psFilename);
		void initShader(const wchar_t* vsFilename, const wchar_t* gsFilename, const wchar_t* psFilename);
		void SetPositions(BillboardPositionsBufferType* ptr, GeometryType type);	//Sets up the vertex positions based on the type of billboard

	private:
		//Buffers for light, camera positions, billboard positions and shadowing
		ID3D11Buffer * shadowMatrixBuffer;
		ID3D11Buffer* billboardBuffer;
		ID3D11Buffer* billboardPositionsBuffer;
		ID3D11Buffer* lightBuffer;
		ID3D11SamplerState* sampleState;
		ID3D11SamplerState* sampleStateShadow;
};
